#!/usr/bin/perl
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Perl script to migrate between ipfm 0.4 and ipfm 0.5 dataformat by
# Reads the old dump from stdin, writes the new dumps to two files:
#  - hosts-dump.sql for the host entries and
#  - traffic-dump.sql for the traffic entries
# These then need to be loaded in this order: first hosts, then trafficentries
#
# The required dump should be created by using pg_dump doing a data-only
# dump of the existing ipfm database.
# 
# author: Alexander Schreiber <als@thangorodrim.de>
# 
# CVS: $Id: dumpmigrate.pl,v 1.6 2004/05/26 20:57:19 als Exp $
#

$| = 1;


# set up the heads of the two files

open(HOSTS, ">hosts-dump.sql") or die "Cannot open hosts-dump.sql";
open(TRAFFIC, ">traffic-dump.sql") or die "Cannot open traffic-dump.sql";

print HOSTS "COPY \"hosts\" FROM stdin;\n";
print TRAFFIC "COPY \"trafficentries\" FROM stdin;\n";

# start reading

$host_id = 0;
$traffic_id = 0;

print "processing entry: 0000000000";

while ( $line = <STDIN> ) {
    chomp($line);
    if ( $line =~ /^\S+\s+(\S+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(\d+)$/ ) {
# ok, valid entry
#        print "date |$1| time |$2| host |$3| in |$4| out |$5|\n";
        $date = $1;
        $time = $2;
        $host = $3;
        $in = $4;
        $out = $5;

# add to host entries
        unless ( defined($hosts{$host}) ) {
            $host_id++;
            $hosts{$host} = $host_id;
            print HOSTS "$host_id\t$host\n";
        }
        $traffic_id++;
        $traffic_line  = "\\N\t$date\t$time\t$hosts{$host}";
        $traffic_line .= "\t$in\t$out\n";
        print TRAFFIC $traffic_line;
        if ( ($traffic_id % 1000) == 0 ) {
            print "\b\b\b\b\b\b\b\b\b\b";
            printf("%10d", $traffic_id);
        }
    } else {
#        print "ERROR: |$line|\n";
    }
}

print HOSTS "\\.\n";
print TRAFFIC "\\.\n";
close(HOSTS);
close(TRAFFIC);


