--
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public
-- License as published by the Free Software Foundation; either
-- version 2 of the License, or (at your option) any later version.
--
-- This library is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of 
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
-- Library General Public License for more details.
--
-- You should have received a copy of the GNU General Public
-- License along with this library; if not, write to the Free
-- Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- The database structure for ipfm2psql
--
-- author: Alexander Schreiber <als@thangorodrim.de>
--
-- CVS: $Id: ipfm.sql,v 1.5 2004/05/26 20:57:19 als Exp $
--


-- hosts table
create table hosts (
                id              serial primary key,
                hostname        varchar not null);

create table trafficentries (
                id              serial primary key,
                date            date,
                time            time,
                host            integer not null
                                        references hosts
                                        on delete cascade,
                incoming        bigint,
                outgoing        bigint);


-- trigger to only insert a new host entry of it does not yet exist
create or replace function hosts_update() returns opaque as
'
DECLARE
  oldentry varchar;
BEGIN
  SELECT hostname INTO oldentry FROM hosts where hostname = NEW.hostname;
  IF oldentry IS NOT NULL THEN
  -- hostname not yet in database
    RETURN NULL;
  END IF;
  RETURN NEW;
END;
'
language 'plpgsql';


create trigger hosts_cond_update before insert on hosts 
        for each row execute procedure hosts_update();


create view trafficlog as
        SELECT t.id, t.date, t.time, h.hostname, t.incoming, t.outgoing 
                from trafficentries t, hosts h 
                where t.host = h.id;

CREATE INDEX hostname_index on hosts using BTREE (hostname);
CREATE INDEX date_index on trafficentries using BTREE (date);

