#!/usr/bin/perl
#
# finger-mrtg.pl -
#
#       executes "finger @hostname" (hostname is the argument passed into
#       the script) and counts how many logins there currently are on that 
#       machine.
#       
#       if machine is 'localhost', we just execute 'finger' instead, w/ no 
#       arguments.
#
#       example Target line:
#       
#       Target[shellbox1]: `/path/to/finger-mrtg.pl shellbox1.mydomain.com`
#
#
# -joey miller, inficad communications, llc.
#  <joeym@inficad.com>
#
# version: $Id: finger.pl,v 1.3 2002/08/15 11:08:58 als Exp $
# updated by Alexander Schreiber <als@thangorodrim.de>
#

if ( ! $ARGV[0] ) { 
    print "usage: $0 [hostname]\n";
    exit; 
}

# output:
#
# [user1.inficad.com]
# Login    Name                 Tty   Idle  Login Time   Office     Office Phone
# username blah blah            *pd     43  Feb  3 16:55
# hello    lada lada             pa   5:16  Feb  3 15:21

if ( $ARGV[0] =~ /localhost/ ) {
    open(FINGER, "/usr/bin/finger |") || exit;
} else {
    open(FINGER, "/usr/bin/finger \@$ARGV[0] |") || exit;
}

$count = 0;
while (<FINGER>) {
  if ( /^\[.*\]/ ) { next; }
  if ( /^Login/ ) { next; }
  if ( /^No one logged on.$/ ) { next; }
  $count++;
}

print "$count\n";
print "$count\n";
print "0\n";
print "$ARGV[0]\n";

