#!/usr/bin/perl -w
# This script is used to get the disk information provided by showdisk.pl
# via ssh from a host who doesn't provide this information via simple
# TCP ports.
#
# use: ./getdisk-ssh.pl <hostname> <mount point>
#
# $Id: getdisk-ssh.pl,v 1.3 2002/08/14 17:00:43 als Exp $
#
# Based on getdisk.pl by Steven Micallef <smic@wire.net.au> on the 24/4/1999.
#
# Modified to support ssh as a transport for getting the data instead of
# simple TCP ports.
#
# Modified again by Alexander Schreiber <als@thangorodrim.de> to adapt to the
# changes in showdisk.pl. Now uses mount point instead of disk number.
# Added "use strict" and rewrote to script to comply with this.
#

use strict;

my ($hostname, $mount_point, $SSH, $CMD, $command, $found, $data);

$hostname = $ARGV[0];
$mount_point = $ARGV[1];
$SSH='/usr/bin/ssh';
$CMD='/opt/mrtgsensors/bin/showdisk.pl';
# If you've changed the port showdisk.pl runs on, change it here too.


if ( scalar(@ARGV) != 2 ) {
  print "Usage: $0 <hostname> <mount point>\n";
  exit;
}

$command = "$SSH $hostname $CMD";

open (PIPE, "$command 2>&1|") or die "Cannot connect to $hostname";

$found = 0;
while ( $data = <PIPE> ) {
    if ( $data =~ /^$mount_point\s+(\d+)$/ ) {
        print "$1\n0\n0\n";
        $found = 1;
    }
}

if ( $found == 0 ) {
    print "0\n0\n0\n";
}

