#!/usr/bin/perl -w
# Displays disk info to the hosts that connect to it.
#
# $Id: showdisk.pl,v 1.4 2002/09/13 23:38:53 als Exp $
#
# No command line options, just put it in /etc/inetd.conf as shown in
# the README file.
#
# By Steven Micallef <smic@wire.net.au> on the 24/4/1999.
#
# Rewritten by Alexander Schreiber <als@thangorodrim.de> 2002-08-09 to:
#   - be portable between at least Linux and FreeBSD (more to come),
#   - work with "use strict",
#   - output both the mountpoint and the used capacity (in percent),
#

use strict;

my ($os, $df);

$df = '';

$os = `uname -s`;
chomp($os);

if ( $os eq 'FreeBSD' ) {   # df has no -l switch here
    $df = 'df -kl';
}

if ( $os eq 'NetBSD' ) {   # df has no -l switch here
    $df = 'df -kl';
}


if ( $df eq '' ) { # df needs -l 
    $df = 'df -klP';
}

my ($device, $size, $used, $free, $percent, $mount);
my $line;

open(PIPE, "$df |") or die "cannot open pipe to $df";

while ( $line = <PIPE> ) {
    chomp($line);
    unless  ( $line =~ /^Filesystem/ ) {
        ($device, $size, $used, $free, $percent, $mount) = split(/\s+/, $line);
        chop($percent);
        print "$mount $percent\n";
    }
}

close(PIPE);


